import sys
input = sys.stdin.readline
from collections import defaultdict

N, Q = map(int, input().split())
a = list(map(int, input().split()))

total_count = [0] * (N+2)
for val in a:
    total_count[val] += 1

# Fenwick Tree ?? ?????????? ?? count_in_hand
class BIT:
    def __init__(self, n):
        self.N = n+2
        self.bit = [0]*(self.N)
    def update(self, i, x):
        i += 1
        while i < self.N:
            self.bit[i] += x
            i += i & -i
    def query(self, i):
        i += 1
        res = 0
        while i > 0:
            res += self.bit[i]
            i -= i & -i
        return res

# Fenwick Tree ?? ????? ????e (a[i] <= N)
pos_BIT = [BIT(N+2) for _ in range(N+2)]
for idx, val in enumerate(a):
    pos_BIT[val].update(idx,1)

for _ in range(Q):
    tmp = input().split()
    t = int(tmp[0])
    if t==1:
        k = int(tmp[1])
        res = 0
        for v in range(1,N+1):
            count_in_hand = pos_BIT[v].query(k-1)
            count_in_deck = total_count[v] - count_in_hand
            res += max(0,count_in_hand - count_in_deck) * v
        print(res)
    else:
        x = int(tmp[1])-1
        y = int(tmp[2])
        old_val = a[x]
        pos_BIT[old_val].update(x,-1)
        pos_BIT[y].update(x,1)
        total_count[old_val] -=1
        total_count[y] +=1
        a[x] = y